/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.inventory;

import dev.ftb.extendedexchange.block.entity.AbstractLinkInvBlockEntity;
import dev.ftb.extendedexchange.config.ConfigHelper;
import dev.ftb.extendedexchange.inventory.BaseItemStackHandler;
import dev.ftb.extendedexchange.offline.KnowledgeProviderCache;
import dev.ftb.extendedexchange.util.EXUtils;
import java.math.BigInteger;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class LinkOutputHandler
extends BaseItemStackHandler<AbstractLinkInvBlockEntity> {
    public LinkOutputHandler(AbstractLinkInvBlockEntity blockEntity, int outputSize) {
        super(blockEntity, outputSize);
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stacks.set(i, (Object)ProjectEAPI.getEMCProxy().getPersistentInfo(ItemInfo.fromStack((ItemStack)((ItemStack)this.stacks.get(i)))).createStack());
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        long value = ProjectEAPI.getEMCProxy().getValue(stack);
        if (value == 0L) {
            return ItemStack.f_41583_;
        }
        IKnowledgeProvider knowledgeProvider = null;
        if (((AbstractLinkInvBlockEntity)this.owningBlockEntity).getStoredEmc() < value && ((knowledgeProvider = KnowledgeProviderCache.getInstance().getCachedProvider(((AbstractLinkInvBlockEntity)this.owningBlockEntity).m_58904_(), ((AbstractLinkInvBlockEntity)this.owningBlockEntity).getOwnerId())) == null || knowledgeProvider.getEmc().compareTo(BigInteger.valueOf(value)) < 0)) {
            return ItemStack.f_41583_;
        }
        ItemStack toExtract = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)Math.min(amount, this.capAmount(knowledgeProvider, value, ConfigHelper.getEMCLinkMaxOutput())));
        if (!toExtract.m_41619_()) {
            if (!simulate) {
                long totalValue = value * (long)toExtract.m_41613_();
                if (((AbstractLinkInvBlockEntity)this.owningBlockEntity).getStoredEmc() >= totalValue) {
                    ((AbstractLinkInvBlockEntity)this.owningBlockEntity).extractEmc(totalValue, IEmcStorage.EmcAction.EXECUTE);
                } else if (knowledgeProvider != null) {
                    knowledgeProvider.setEmc(knowledgeProvider.getEmc().subtract(BigInteger.valueOf(totalValue)));
                    ((AbstractLinkInvBlockEntity)this.owningBlockEntity).trySyncEMC();
                } else {
                    return ItemStack.f_41583_;
                }
            }
            return toExtract;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (((AbstractLinkInvBlockEntity)this.owningBlockEntity).m_58904_().m_5776_()) {
            return this.getItemForDisplay(slot);
        }
        this.validateSlotIndex(slot);
        if ((Long)ConfigHelper.server().general.emcLinkMaxOutput.get() <= 0L) {
            return ItemStack.f_41583_;
        }
        long value = ProjectEAPI.getEMCProxy().getValue((ItemStack)this.stacks.get(slot));
        if (value > 0L) {
            int actualAmount;
            IKnowledgeProvider provider = KnowledgeProviderCache.getInstance().getCachedProvider(((AbstractLinkInvBlockEntity)this.owningBlockEntity).m_58904_(), ((AbstractLinkInvBlockEntity)this.owningBlockEntity).getOwnerId());
            if (provider != null && (actualAmount = this.capAmount(provider, value, ConfigHelper.getEMCLinkMaxOutput())) > 0) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.stacks.get(slot)), (int)actualAmount);
            }
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getItemForDisplay(int slot) {
        return super.getStackInSlot(slot);
    }

    private int capAmount(@Nullable IKnowledgeProvider knowledgeProvider, long value, BigInteger emcLimit) {
        BigInteger emc = knowledgeProvider == null ? BigInteger.valueOf(((AbstractLinkInvBlockEntity)this.owningBlockEntity).getStoredEmc()) : knowledgeProvider.getEmc();
        BigInteger cappedEMC = emc.min(emcLimit);
        if (cappedEMC.compareTo(BigInteger.valueOf(value)) < 0) {
            return 0;
        }
        BigInteger itemCount = value == 1L ? cappedEMC : cappedEMC.divide(BigInteger.valueOf(value));
        return EXUtils.bigIntToInt(itemCount);
    }
}

